import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './DataProtectClient.json';

export class DataProtectClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/dataprotect');
    }
    async forget(generationId,  __fetchOptions = {}) {
        let __path = this.base + '/generations';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
        if (generationId != null) {
            __url.searchParams.append("generationId", generationId);
        }
		return this.__fetchContent(__url, __options);
    }
    async getAvailableGenerations( __fetchOptions = {}) {
        let __path = this.base + '/generations';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getContent(partGen,  __fetchOptions = {}) {
        let __path = this.base + '/_content/{partGen}';
        __path = __path.replace('{partGen}', encodeURIComponent(partGen));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getRestoreCapabilities( __fetchOptions = {}) {
        let __path = this.base + '/restore/_capabilities';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getRestoreCapabilitiesByTags(tags,  __fetchOptions = {}) {
        let __path = this.base + '/restore/_capabilities_by_tags';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (tags != null) {
            __options.body = JSON.stringify(tags);
        }
		return this.__fetchContent(__url, __options);
    }
    async getRetentionPolicy( __fetchOptions = {}) {
        let __path = this.base + '/policy';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async run(restoreDefinition,  __fetchOptions = {}) {
        let __path = this.base + '/restore';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (restoreDefinition != null) {
            __options.body = JSON.stringify(restoreDefinition);
        }
		return this.__fetchContent(__url, __options);
    }
    async saveAll( __fetchOptions = {}) {
        let __path = this.base + '/_backup';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async syncWithFilesystem( __fetchOptions = {}) {
        let __path = this.base + '/_syncfs';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async updatePolicy(rp,  __fetchOptions = {}) {
        let __path = this.base + '/policy';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (rp != null) {
            __options.body = JSON.stringify(rp);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
