
import { VEventSeries } from "./VEventSeries"; 
import { VEventQuery } from "./VEventQuery"; 
import { VEventChanges } from "./VEventChanges"; 
import { VEventRange } from "./VEventRange"; 
import { 
    TaskRef
} from "@bluemind/core.task.api";
import { 
    ContainerChangeset,
    ItemFlagFilter,
    ItemValue,
    Ack,
    SortDescriptor,
    ContainerUpdatesResult,
    Count,
    ItemChangelog,
    ItemVersion
} from "@bluemind/core.container.api";
import { 
    ListResult
} from "@bluemind/core.foldershare.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Calendar operations.
 */
export interface ICalendar {
    /**
     * Returns all the items uid from the container.
     * @returns all the items uid from the container.
     */
    all( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    count(arg0?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<Count>;
    /**
     * Creates a {@link VEvent}.
     * @param uid the unique identifier for the new event
     * @param event the {@link VEventSeries} to store
     * @param sendNotifications if <code>true</code> then notify this event creation
     *                          on the events bus
     */
    create(uid: string, event?: VEventSeries, sendNotifications?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    createById(id: number, arg1?: VEventSeries,  __fetchOptions?: RequestOptions): Promise<Ack>;
    /**
     * Deletes the {@link VEventSeries} identified by the given unique identifier.
     * @param uid the unique identifier of the event
     * @param sendNotifications if <code>true</code> then notify this event deletion
     *                          on the events bus
     */
    delete(uid: string, sendNotifications?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteById(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    /**
     * Returns all {@link VEventSeries} matching the given ICS unique identifier.
     * @param uid the ICS unique identifier
     * @returns the list of matching {@link VEventSeries}
     */
    getByIcsUid(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VEventSeries>>>;
    /**
     * Returns the {@link VEventSeries} identified by the given unique identifier.
     * @param uid the unique identifier of the event
     * @returns a {@link VEventSeries} if successful
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<VEventSeries>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<VEventSeries>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    /**
     * Check the automatic synchronization is activated for this calendar.
     * @returns <code>true</code> if this calendar is automatically synchronized,
     *         <code>false</code> otherwise
     */
    isAutoSyncActivated( __fetchOptions?: RequestOptions): Promise<boolean>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    /**
     * List all the events of this calendar.
     * @returns all the {@link VEventSeries}
     */
    list( __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VEventSeries>>>;
    multipleDeleteById(arg0?: Array<number>, bypassDeletedItems?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Fetch multiple {@link VEventSeries} identified by the given unique
     * identifiers.
     * @param uids the list of unique identifiers
     * @returns all matching {@link VEventSeries}
     */
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VEventSeries>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VEventSeries>>>;
    /**
     * Fetch multiple {@link VEventSeries} identified by the given range
     * @param range {@link VEventRange}
     * @returns all matching {@link VEventSeries}
     */
    multipleGetByRange(range?: VEventRange,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VEventSeries>>>;
    /**
     * Remove all events from this calendar.
     * @returns the reference to this asynchronous operation
     */
    reset( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Search for events matching the given query.
     * @param query the {@link VEventQuery} to match against
     * @returns the matching {@link VEventSeries}
     */
    search(query?: VEventQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VEventSeries>>>;
    /**
     * Search pending counters of the current user
     * @returns 
     */
    searchPendingCounters( __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VEventSeries>>>;
    sortedIds(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    sortedUids(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Apply the given changes and return the differences since the given time.
     * CLIENT_WIN style.
     * @param since the time from wich compare changes
     * @param changes the changes to apply
     * @returns the {@link ContainerChangeset} of the difSortDescriptorferences
     */
    sync(since?: number, changes?: VEventChanges,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    /**
     * Touch a {@link VEvent}.
     * @param uid the unique identifier of the event
     */
    touch(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Updates a {@link VEventSeries}.
     * @param uid the unique identifier of the event
     * @param event the {@link VEventSeries} to update
     * @param sendNotifications if <code>true</code> then notify this event creation
     *                          on the events bus
     */
    update(uid: string, event?: VEventSeries, sendNotifications?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    updateById(id: number, arg1?: VEventSeries,  __fetchOptions?: RequestOptions): Promise<Ack>;
    /**
     * Applies changes (create, update, delete) to a calendar specified by its
     * <code>containerUid</code>.
     * @param changes the changes to apply
     */
    updates(changes?: VEventChanges,  __fetchOptions?: RequestOptions): Promise<ContainerUpdatesResult>;
}

export declare class CalendarClient extends ApiEndPoint implements ICalendar {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    all( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    count(arg0?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<Count>;
    create(uid: string, event?: VEventSeries, sendNotifications?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    createById(id: number, arg1?: VEventSeries,  __fetchOptions?: RequestOptions): Promise<Ack>;
    delete(uid: string, sendNotifications?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteById(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getByIcsUid(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VEventSeries>>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<VEventSeries>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<VEventSeries>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    isAutoSyncActivated( __fetchOptions?: RequestOptions): Promise<boolean>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    list( __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VEventSeries>>>;
    multipleDeleteById(arg0?: Array<number>, bypassDeletedItems?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VEventSeries>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VEventSeries>>>;
    multipleGetByRange(range?: VEventRange,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VEventSeries>>>;
    reset( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    search(query?: VEventQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VEventSeries>>>;
    searchPendingCounters( __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VEventSeries>>>;
    sortedIds(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    sortedUids(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    sync(since?: number, changes?: VEventChanges,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    touch(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, event?: VEventSeries, sendNotifications?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    updateById(id: number, arg1?: VEventSeries,  __fetchOptions?: RequestOptions): Promise<Ack>;
    updates(changes?: VEventChanges,  __fetchOptions?: RequestOptions): Promise<ContainerUpdatesResult>;
    getMetadata(): EndPointMetadata;
}
