
export type ImportMailboxItemsStatus = {
    /**
     * Source MailboxItem id as key, destination MailboxItem id as value
     */
    doneIds?: Array<ImportMailboxItemsStatus.ImportedMailboxItem>;
    status?: ImportMailboxItemsStatus.ImportStatus;
};
export namespace ImportMailboxItemsStatus {
    export type ImportedMailboxItem = {
        source?: number;
        destination?: number;
    };
    export type ImportStatus =  "SUCCESS" |  "PARTIAL" |  "ERROR";
    export const ImportStatus : {
        readonly SUCCESS: ImportStatus,
        readonly PARTIAL: ImportStatus,
        readonly ERROR: ImportStatus
    };

}
