import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './APIKeysClient.json';

export class APIKeysClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/auth/keys');
    }
    async create(displayName,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (displayName != null) {
            __url.searchParams.append("displayName", displayName);
        }
		return this.__fetchContent(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async list( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async put(displayName, sid,  __fetchOptions = {}) {
        let __path = this.base + '/_put';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (displayName != null) {
            __url.searchParams.append("displayName", displayName);
        }
        if (sid != null) {
            __options.body = JSON.stringify(sid);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
