import { 
    ContainerChangeset,
    ItemFlagFilter,
    Ack,
    ItemChangelog,
    ItemValue,
    ItemVersion
} from "@bluemind/core.container.api";

import { WebAppData } from "./WebAppData"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * WebAppData API - allow to save web applications data. All methods work on
 * {@link WebAppData} in a specific container identified by a unique UID, see
 * {@link WebAppData.getContainerUid}. Use
 * {@link net.bluemind.core.container.api.IContainers#all} to lookup all
 * containers of specific type.
 */
export interface IWebAppData {
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    create(uid: string, arg1?: WebAppData,  __fetchOptions?: RequestOptions): Promise<Ack>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteAll( __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getByKey(key: string,  __fetchOptions?: RequestOptions): Promise<WebAppData>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<WebAppData>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<WebAppData>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    multipleGet(arg0?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<WebAppData>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<WebAppData>>>;
    update(uid: string, arg1?: WebAppData,  __fetchOptions?: RequestOptions): Promise<Ack>;
}

export declare class WebAppDataClient extends ApiEndPoint implements IWebAppData {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    create(uid: string, arg1?: WebAppData,  __fetchOptions?: RequestOptions): Promise<Ack>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteAll( __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getByKey(key: string,  __fetchOptions?: RequestOptions): Promise<WebAppData>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<WebAppData>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<WebAppData>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    multipleGet(arg0?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<WebAppData>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<WebAppData>>>;
    update(uid: string, arg1?: WebAppData,  __fetchOptions?: RequestOptions): Promise<Ack>;
    getMetadata(): EndPointMetadata;
}
