import { 
    BaseDirEntry
} from "@bluemind/directory.api";
/**
 * Declaration of a role.
 */
export type RoleDescriptor = {
    /**
     * Unique identifier.
     */
    id?: string;
    /**
     * Parent role, this role inherits all permissions of the parent role.
     */
    parentRoleId?: string;
    /**
     * Associated {@link RoleCategory}.
     */
    categoryId?: string;
    /**
     * Label.
     */
    label?: string;
    /**
     * Role description.
     */
    description?: string;
    /**
     * Role applies to own roles only.
     */
    selfPromote?: boolean;
    /**
     * Role applies to associated directory entry.
     */
    dirEntryPromote?: boolean;
    /**
     * Role applies to specific directory entry kind.
     */
    dirEntryKind?: BaseDirEntry.Kind;
    /**
     * Sibling role //FIXME explain
     */
    siblingRole?: string;
    /**
     * Child roles.
     */
    childsRole?: Array<string>;
    /**
     * Visible in administration.
     */
    visible?: boolean;
    /**
     * Role can be delegated.
     */
    delegable?: boolean;
    /**
     * Role applies to containers.
     */
    containerRoles?: Array<string>;
    /**
     * Role priority //FIXME unused
     */
    priority?: number;
};
