import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './MailshareClient.json';

export class MailshareClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, domainUid , base = '') {
        super(apiKey, base + '/api/mailshares/{domainUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
    }
    async allComplete( __fetchOptions = {}) {
        let __path = this.base + '/_complete';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async byEmail(email,  __fetchOptions = {}) {
        let __path = this.base + '/_byemail';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (email != null) {
            __url.searchParams.append("email", email);
        }
		return this.__fetchContent(__url, __options);
    }
    async create(uid, mailshare,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (mailshare != null) {
            __options.body = JSON.stringify(mailshare);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async deletePhoto(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/photo';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/complete';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getIcon(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/icon';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getPhoto(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/photo';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async setPhoto(uid, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/photo';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchVoid(__url, __options);
    }
    async update(uid, mailshare,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (mailshare != null) {
            __options.body = JSON.stringify(mailshare);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
