import { 
    TaskRef
} from "@bluemind/core.task.api";

import { Mailshare } from "./Mailshare"; 
import { 
    ItemValue
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IMailshare {
    /**
     * Fetches all Mailshares
     * @returns list of all Mailshares
     */
    allComplete( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Mailshare>>>;
    byEmail(email?: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Mailshare>>;
    /**
     * Creates a new {@link Mailshare} entry.<br/>
     *
     * Since version 5.5, Mailshare creation has been disabled in favor of shared mailbox creation. <br/>
     * To do this, use PUT /users/{domainUid}/{uid} with the User loginCaps set to false. <br/>
     *
     * However, it is possible, particularly for testing purposes, <br/>
     * to use an internal API to continue creating Mailshares using <br/>
     * IInternalMailshare.createMailshare() <br/>
     * @param uid uid of the entry
     * @param mailshare value of the entry
     * @deprecated 
     */
    create(uid: string, mailshare?: Mailshare,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete {@link Mailshare} entry
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    deletePhoto(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Fetch a {@link Mailshare} from its unique uid
     * @returns {@link ItemValue<Mailshare>}
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Mailshare>>;
    getIcon(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    getPhoto(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    setPhoto(uid: string, arg1?: ArrayBuffer,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Modifies an existing {@link Mailshare} entry.
     * @param uid uid of the entry
     * @param mailshare value of the entry
     */
    update(uid: string, mailshare?: Mailshare,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class MailshareClient extends ApiEndPoint implements IMailshare {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    allComplete( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Mailshare>>>;
    byEmail(email?: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Mailshare>>;
    create(uid: string, mailshare?: Mailshare,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    deletePhoto(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Mailshare>>;
    getIcon(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    getPhoto(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    setPhoto(uid: string, arg1?: ArrayBuffer,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, mailshare?: Mailshare,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
