import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * API for managing domain-wide settings. This {@link DomainSettingsKeys} enum
 * contains a non-exhaustive list of domain settings keys.
 */
export interface IDomainSettings {
    /**
     * Fetch domain settings.
     * @returns domain settings map
     */
    get( __fetchOptions?: RequestOptions): Promise<Record<string, string>>;
    /**
     * Define domain settings.
     * @param settings domain settings map
     */
    set(settings?: Record<string, string>,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class DomainSettingsClient extends ApiEndPoint implements IDomainSettings {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    get( __fetchOptions?: RequestOptions): Promise<Record<string, string>>;
    set(settings?: Record<string, string>,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
