import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './DeviceClient.json';

export class DeviceClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, userUid , base = '') {
        super(apiKey, base + '/api/devices/{userUid}');
        this.userUid = userUid;
        this.base = this.base.replace('{userUid}', encodeURIComponent(userUid));
    }
    async byIdentifier(identifier,  __fetchOptions = {}) {
        let __path = this.base + '/{identifier}/byIdentifier';
        __path = __path.replace('{identifier}', encodeURIComponent(identifier));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async create(uid, device,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (device != null) {
            __options.body = JSON.stringify(device);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async deleteAll( __fetchOptions = {}) {
        let __path = this.base + '/_deleteAll';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/complete';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async list( __fetchOptions = {}) {
        let __path = this.base + '/_list';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async setPartnership(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_partnership';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async unsetPartnership(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_partnership';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async unwipe(uid,  __fetchOptions = {}) {
        let __path = this.base + '/_unwipe/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async update(uid, device,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (device != null) {
            __options.body = JSON.stringify(device);
        }
		return this.__fetchVoid(__url, __options);
    }
    async updateLastSync(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_lastSync';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async wipe(uid, mode,  __fetchOptions = {}) {
        let __path = this.base + '/_wipe/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (mode != null) {
            __options.body = JSON.stringify(mode);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
