import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './SharedContainersClient.json';

export class SharedContainersClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, domainUid , ownerUid , base = '') {
        super(apiKey, base + '/api/containers/{domainUid}/{ownerUid}/_shared');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
        this.ownerUid = ownerUid;
        this.base = this.base.replace('{ownerUid}', encodeURIComponent(ownerUid));
    }
    async getSharedContainers(type,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (type != null) {
            __url.searchParams.append("type", type);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
