
import { SharedContainer } from "./SharedContainer"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface ISharedContainers {
    /**
     * Get all Containers
     * ({@link net.bluemind.core.container.model.SharedContainer}) shared by
     * ownerUid
     * @param type the container's type
     * @returns a list of containers for the given type and their
     *         {@link net.bluemind.core.container.model.acl.AccessControlEntry}
     *         information
     */
    getSharedContainers(type?: string,  __fetchOptions?: RequestOptions): Promise<Array<SharedContainer>>;
}

export declare class SharedContainersClient extends ApiEndPoint implements ISharedContainers {
    domainUid: string;
    ownerUid: string;
    constructor(apiKey: string, domainUid: string, ownerUid: string, base?: string);
    getSharedContainers(type?: string,  __fetchOptions?: RequestOptions): Promise<Array<SharedContainer>>;
    getMetadata(): EndPointMetadata;
}
