import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './OwnerSubscriptionUidsClient.json';

export class OwnerSubscriptionUidsClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/owner_subscriptions/uids');
    }
    async identifier(uid, domain,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/{domain}/_subscription';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        __path = __path.replace('{domain}', encodeURIComponent(domain));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
