import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './ContainerManagementClient.json';

export class ContainerManagementClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/containers/_manage/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async allowOfflineSync(subject,  __fetchOptions = {}) {
        let __path = this.base + '/{subject}/offlineSync';
        __path = __path.replace('{subject}', encodeURIComponent(subject));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async canAccess(verbsOrRoles,  __fetchOptions = {}) {
        let __path = this.base + '/_canAccess';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (verbsOrRoles != null) {
            __options.body = JSON.stringify(verbsOrRoles);
        }
		return this.__fetchContent(__url, __options);
    }
    async canAccessVerbs(verbsOrRoles,  __fetchOptions = {}) {
        let __path = this.base + '/_canAccessVerbs';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (verbsOrRoles != null) {
            __options.body = JSON.stringify(verbsOrRoles);
        }
		return this.__fetchContent(__url, __options);
    }
    async disallowOfflineSync(subject,  __fetchOptions = {}) {
        let __path = this.base + '/{subject}/offlineSync';
        __path = __path.replace('{subject}', encodeURIComponent(subject));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async getAccessControlList( __fetchOptions = {}) {
        let __path = this.base + '/_acl';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getAllItems( __fetchOptions = {}) {
        let __path = this.base + '/_list';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getDescriptor( __fetchOptions = {}) {
        let __path = this.base + '/_descriptor';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getItemCount( __fetchOptions = {}) {
        let __path = this.base + '/_itemCount';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getItems(uids,  __fetchOptions = {}) {
        let __path = this.base + '/_mget';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (uids != null) {
            __options.body = JSON.stringify(uids);
        }
		return this.__fetchContent(__url, __options);
    }
    async getSettings( __fetchOptions = {}) {
        let __path = this.base + '/_settings';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async setAccessControlList(entries,  __fetchOptions = {}) {
        let __path = this.base + '/_acl';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (entries != null) {
            __options.body = JSON.stringify(entries);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setPersonalSettings(settings,  __fetchOptions = {}) {
        let __path = this.base + '/_personalSettings';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (settings != null) {
            __options.body = JSON.stringify(settings);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setSetting(key, value,  __fetchOptions = {}) {
        let __path = this.base + '/_settings/{key}';
        __path = __path.replace('{key}', encodeURIComponent(key));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (value != null) {
            __options.body = JSON.stringify(value);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setSettings(settings,  __fetchOptions = {}) {
        let __path = this.base + '/_settings';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (settings != null) {
            __options.body = JSON.stringify(settings);
        }
		return this.__fetchVoid(__url, __options);
    }
    async subscribers( __fetchOptions = {}) {
        let __path = this.base + '/_subscription';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async update(descriptor,  __fetchOptions = {}) {
        let __path = this.base + '/_descriptor';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (descriptor != null) {
            __options.body = JSON.stringify(descriptor);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
