import { 
    BmDateTime
} from "@bluemind/core.foldershare.api";
export type BmDateTime = {
    /**
     * ISO8601 date format : - yyyyMMddTHHmmss.SSSZ - yyyyMMddTHHmmss.SSS - yyyyMMdd
     * The date timezone must match the {{@link #timezone} field.
     */
    iso8601?: string;
    /**
     * Date timezone. Can be null or the date do not have timezone.
     */
    timezone?: string;
    /**
     * Precision in the form of Date or DateTime
     */
    precision?: BmDateTime.Precision;
};
export namespace BmDateTime {
    export type Precision =  "Date" |  "DateTime";
    export const Precision : {
        readonly Date: Precision,
        readonly DateTime: Precision
    };

}
