import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './UserCalendarViewsClient.json';

export class UserCalendarViewsClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, domainUid , userUid , base = '') {
        super(apiKey, base + '/api/users/{domainUid}/{userUid}/calendar-views');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
        this.userUid = userUid;
        this.base = this.base.replace('{userUid}', encodeURIComponent(userUid));
    }
    async changeset(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changeset';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async changesetById(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async create(uid, view,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (view != null) {
            __options.body = JSON.stringify(view);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async filteredChangesetById(since, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/_filteredChangesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getCompleteById(id,  __fetchOptions = {}) {
        let __path = this.base + '/{id}/completeById';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getVersion( __fetchOptions = {}) {
        let __path = this.base + '/_version';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async list( __fetchOptions = {}) {
        let __path = this.base + '/_list';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async multipleGet(uids,  __fetchOptions = {}) {
        let __path = this.base + '/_mget';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (uids != null) {
            __options.body = JSON.stringify(uids);
        }
		return this.__fetchContent(__url, __options);
    }
    async multipleGetById(arg0,  __fetchOptions = {}) {
        let __path = this.base + '/_mgetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchContent(__url, __options);
    }
    async setDefault(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_asdefault';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async update(uid, view,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (view != null) {
            __options.body = JSON.stringify(view);
        }
		return this.__fetchVoid(__url, __options);
    }
    async updates(changes,  __fetchOptions = {}) {
        let __path = this.base + '/_mupdates';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (changes != null) {
            __options.body = JSON.stringify(changes);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
