import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './PublicFreebusyClient.json';

export class PublicFreebusyClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/calendars/sfreebusy');
    }
    async get(email, callerUserUid, callerDomain, query,  __fetchOptions = {}) {
        let __path = this.base + '/{email}';
        __path = __path.replace('{email}', encodeURIComponent(email));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (callerUserUid != null) {
            __url.searchParams.append("callerUserUid", callerUserUid);
        }
        if (callerDomain != null) {
            __url.searchParams.append("callerDomain", callerDomain);
        }
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async getAsString(email, callerUserUid, callerDomain, query,  __fetchOptions = {}) {
        let __path = this.base + '/{email}/_ics';
        __path = __path.replace('{email}', encodeURIComponent(email));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (callerUserUid != null) {
            __url.searchParams.append("callerUserUid", callerUserUid);
        }
        if (callerDomain != null) {
            __url.searchParams.append("callerDomain", callerDomain);
        }
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async simple(email, callerUserUid, callerDomain,  __fetchOptions = {}) {
        let __path = this.base + '/{email}';
        __path = __path.replace('{email}', encodeURIComponent(email));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (callerUserUid != null) {
            __url.searchParams.append("callerUserUid", callerUserUid);
        }
        if (callerDomain != null) {
            __url.searchParams.append("callerDomain", callerDomain);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
