import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './AddressBooksMgmtClient.json';

export class AddressBooksMgmtClient extends ApiEndPoint {
    version = "5.5.3112";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/mgmt/addressbooks');
    }
    async backup(containerUid, since,  __fetchOptions = {}) {
        let __path = this.base + '/{containerUid}/_backupstream';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', '*/*', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
        return this.__fetchBlob(__url, __options);
    }
    async create(containerUid, descriptor, isDefault,  __fetchOptions = {}) {
        let __path = this.base + '/{containerUid}';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (isDefault != null) {
            __url.searchParams.append("isDefault", isDefault);
        }
        if (descriptor != null) {
            __options.body = JSON.stringify(descriptor);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(containerUid,  __fetchOptions = {}) {
        let __path = this.base + '/{containerUid}';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async getComplete(containerUid,  __fetchOptions = {}) {
        let __path = this.base + '/{containerUid}';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async reindex(containerUid,  __fetchOptions = {}) {
        let __path = this.base + '/{containerUid}/_reindex';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async reindexAll( __fetchOptions = {}) {
        let __path = this.base + '/_reindex';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async reindexDomain(domain,  __fetchOptions = {}) {
        let __path = this.base + '/_reindexDomain';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (domain != null) {
            __url.searchParams.append("domain", domain);
        }
		return this.__fetchContent(__url, __options);
    }
    async restore(containerUid, restoreStream, reset,  __fetchOptions = {}) {
        let __path = this.base + '/{containerUid}/_restorestream';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (reset != null) {
            __url.searchParams.append("reset", reset);
        }
        if (restoreStream != null) {
            __options.body = restoreStream;
        }
		return this.__fetchVoid(__url, __options);
    }
    async update(containerUid, descriptor,  __fetchOptions = {}) {
        let __path = this.base + '/{containerUid}';
        __path = __path.replace('{containerUid}', encodeURIComponent(containerUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (descriptor != null) {
            __options.body = JSON.stringify(descriptor);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
