
import { BlueMindVideoTokenResponse } from "./BlueMindVideoTokenResponse"; 
import { BlueMindVideoRoom } from "./BlueMindVideoRoom"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IVideoConferencingSaas {
    create(room?: BlueMindVideoRoom,  __fetchOptions?: RequestOptions): Promise<BlueMindVideoRoom>;
    get(roomName: string,  __fetchOptions?: RequestOptions): Promise<BlueMindVideoRoom>;
    token(roomName: string,  __fetchOptions?: RequestOptions): Promise<BlueMindVideoTokenResponse>;
    updateTitle(roomName: string, title?: string,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class VideoConferencingSaasClient extends ApiEndPoint implements IVideoConferencingSaas {
    constructor(apiKey: string, base?: string);
    create(room?: BlueMindVideoRoom,  __fetchOptions?: RequestOptions): Promise<BlueMindVideoRoom>;
    get(roomName: string,  __fetchOptions?: RequestOptions): Promise<BlueMindVideoRoom>;
    token(roomName: string,  __fetchOptions?: RequestOptions): Promise<BlueMindVideoTokenResponse>;
    updateTitle(roomName: string, title?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
