import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './VideoConferencingClient.json';

export class VideoConferencingClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/videoconferencing/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async add(vevent,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (vevent != null) {
            __options.body = JSON.stringify(vevent);
        }
		return this.__fetchContent(__url, __options);
    }
    async createResource(uid, descriptor,  __fetchOptions = {}) {
        let __path = this.base + '/createResource/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (descriptor != null) {
            __options.body = JSON.stringify(descriptor);
        }
		return this.__fetchVoid(__url, __options);
    }
    async remove(vevent,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
        if (vevent != null) {
            __options.body = JSON.stringify(vevent);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
