import { 
    ContainerSubscriptionDescriptor,
    ContainerSubscription
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IUserSubscription {
    /**
     * List subscribed containers
     */
    listSubscriptions(subject: string, type?: string,  __fetchOptions?: RequestOptions): Promise<Array<ContainerSubscriptionDescriptor>>;
    /**
     * Subscribe current User to a list of containers
     */
    subscribe(subject: string, subscriptions?: Array<ContainerSubscription>,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Returns of list of subscribers to a given container
     * @returns list of subscribers uid (as in {@link DirEntry#entryUid})
     */
    subscribers(containerUid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Unsubscribe current User from a list of containers
     */
    unsubscribe(subject: string, containers?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
    updateAutomount(subject: string, subscriptions?: Array<ContainerSubscription>,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class UserSubscriptionClient extends ApiEndPoint implements IUserSubscription {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    listSubscriptions(subject: string, type?: string,  __fetchOptions?: RequestOptions): Promise<Array<ContainerSubscriptionDescriptor>>;
    subscribe(subject: string, subscriptions?: Array<ContainerSubscription>,  __fetchOptions?: RequestOptions): Promise<void>;
    subscribers(containerUid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    unsubscribe(subject: string, containers?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
    updateAutomount(subject: string, subscriptions?: Array<ContainerSubscription>,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
