import { 
    ContainerChangeset,
    ItemFlagFilter,
    ItemValue,
    Ack,
    SortDescriptor,
    ContainerUpdatesResult,
    Count,
    ItemChangelog,
    ItemVersion
} from "@bluemind/core.container.api";

import { VTodo } from "./VTodo"; 
import { VTodoChanges } from "./VTodoChanges"; 
import { VTodoQuery } from "./VTodoQuery"; 
import { 
    ListResult
} from "@bluemind/core.foldershare.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Todolist API. All methods work on Todos in a specific container identified by
 * a unique UID, see {@link ITodoUids}. Use
 * {@link net.bluemind.core.container.api.IContainers#all} to lookup all
 * containers of specific type.
 */
export interface ITodoList {
    /**
     * List all Tasks of a Todolist container
     * @returns All {@link VTodo} of the container
     */
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VTodo>>>;
    /**
     * Retrieve all {@link VTodo} UIDs of this Todolist
     * @returns List of UIDs
     */
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    /**
     * Copy {@link VTodo}s to another Todolist
     * @param uids list of unique UIDs
     */
    copy(uids?: Array<string>, destContainerUid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    count(arg0?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<Count>;
    /**
     * Creates a new {@link VTodo} entry.
     * @param uid Unique entry UID
     * @param todo {@link VTodo} values
     */
    create(uid: string, todo?: VTodo,  __fetchOptions?: RequestOptions): Promise<void>;
    createById(id: number, arg1?: VTodo,  __fetchOptions?: RequestOptions): Promise<Ack>;
    /**
     * Delete a {@link VTodo}
     * @param uid unique UID
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteById(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    /**
     * Returns all {@link VTodo} matching the given ICS unique identifier.
     * @param uid the ICS unique identifier
     * @returns the list of matching {@link VTodo}
     */
    getByIcsUid(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VTodo>>>;
    /**
     * Fetch a {@link VTodo} by its unique UID
     * @param uid Unique entry UID
     * @returns {@link net.bluemind.core.container.model.ItemValue} containing a
     *         {@link VTodo}
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<VTodo>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<VTodo>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    /**
     * Move {@link VTodo}s to another Todolist
     * @param uids list of unique UIDs
     */
    move(uids?: Array<string>, destContainerUid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleDeleteById(arg0?: Array<number>, bypassDeletedItems?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Fetch multiple {@link VTodo}s by their unique UIDs
     * @param uids list of unique UIDs
     * @returns list of {@link net.bluemind.core.container.model.ItemValue}s
     *         containing {@link VTodo}s
     */
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VTodo>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VTodo>>>;
    /**
     * Delete all {@link VTodo}s of this Todolist
     */
    reset( __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Search {@link VTodo}'s by {@link VTodoQuery}
     * @param query {@link VTodoQuery}
     * @returns {@link net.bluemind.core.api.ListResult} of the matching
     *         {@link net.bluemind.core.container.model.ItemValue}s containing a
     *         {@link VTodo}
     */
    search(query?: VTodoQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VTodo>>>;
    sortedIds(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    sortedUids(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Client/Server synchronization of {@link VTodo}s. Applies client changes and
     * returns server updates happened since {@code since} parameter.
     * @param since timestamp of the requested server updates
     * @param changes client updates
     * @returns {@link net.bluemind.core.container.model.ContainerChangeset}
     *         containing the server updates
     */
    sync(since?: number, changes?: VTodoChanges,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    /**
     * Modifies an existing {@link VTodo}.
     * @param uid Unique entry UID
     * @param todo {@link VTodo} values
     */
    update(uid: string, todo?: VTodo,  __fetchOptions?: RequestOptions): Promise<void>;
    updateById(id: number, arg1?: VTodo,  __fetchOptions?: RequestOptions): Promise<Ack>;
    /**
     * Updates multiple {@link VTodo}s.
     * @param changes {@link VTodoChanges} containing the requested updates
     * @returns {@link net.bluemind.core.container.model.ContainerUpdatesResult}
     */
    updates(changes?: VTodoChanges,  __fetchOptions?: RequestOptions): Promise<ContainerUpdatesResult>;
}

export declare class TodoListClient extends ApiEndPoint implements ITodoList {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VTodo>>>;
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    copy(uids?: Array<string>, destContainerUid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    count(arg0?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<Count>;
    create(uid: string, todo?: VTodo,  __fetchOptions?: RequestOptions): Promise<void>;
    createById(id: number, arg1?: VTodo,  __fetchOptions?: RequestOptions): Promise<Ack>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteById(id: number,  __fetchOptions?: RequestOptions): Promise<void>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getByIcsUid(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VTodo>>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<VTodo>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<VTodo>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    move(uids?: Array<string>, destContainerUid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleDeleteById(arg0?: Array<number>, bypassDeletedItems?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VTodo>>>;
    multipleGetById(arg0?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<VTodo>>>;
    reset( __fetchOptions?: RequestOptions): Promise<void>;
    search(query?: VTodoQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<VTodo>>>;
    sortedIds(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<number>>;
    sortedUids(arg0?: SortDescriptor,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    sync(since?: number, changes?: VTodoChanges,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    update(uid: string, todo?: VTodo,  __fetchOptions?: RequestOptions): Promise<void>;
    updateById(id: number, arg1?: VTodo,  __fetchOptions?: RequestOptions): Promise<Ack>;
    updates(changes?: VTodoChanges,  __fetchOptions?: RequestOptions): Promise<ContainerUpdatesResult>;
    getMetadata(): EndPointMetadata;
}
