import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * API for managing domain-wide settings.
 */
export interface IGlobalSettings {
    /**
     * Delete a global settings value
     * @param key key
     */
    delete(key?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Get global settings
     * @returns {@link ItemValue}&lt;Map&lt;String, String>> global settings
     */
    get( __fetchOptions?: RequestOptions): Promise<Record<string, string>>;
    /**
     * Set global settings
     * @param settings settings values
     */
    set(settings?: Record<string, string>,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class GlobalSettingsClient extends ApiEndPoint implements IGlobalSettings {
    constructor(apiKey: string, base?: string);
    delete(key?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    get( __fetchOptions?: RequestOptions): Promise<Record<string, string>>;
    set(settings?: Record<string, string>,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
