import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './SmimeCacertUidsClient.json';

export class SmimeCacertUidsClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/smime_cacerts/uids');
    }
    async getDomainCreatedCerts(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_domain';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
