import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './ResourceTypesClient.json';

export class ResourceTypesClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, domainUid , base = '') {
        super(apiKey, base + '/api/resources/{domainUid}/type');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
    }
    async create(identifier, resourceTypeDescriptor,  __fetchOptions = {}) {
        let __path = this.base + '/{identifier}';
        __path = __path.replace('{identifier}', encodeURIComponent(identifier));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (resourceTypeDescriptor != null) {
            __options.body = JSON.stringify(resourceTypeDescriptor);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async get(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getIcon(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/icon';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getTypes( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async setIcon(uid, icon,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/icon';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (icon != null) {
            __options.body = JSON.stringify(icon);
        }
		return this.__fetchVoid(__url, __options);
    }
    async update(uid, resourceTypeDescriptor,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (resourceTypeDescriptor != null) {
            __options.body = JSON.stringify(resourceTypeDescriptor);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
