
import { Identity } from "./Identity"; 
import { IdentityDescription } from "./IdentityDescription"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IMailboxIdentity {
    /**
     * Create an {@link Identity}. An {@link Identity} can be used by a user to set
     * the from header in a mail and add a signature.
     * @param identity 
     */
    create(uid: string, identity?: Identity,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete an existing {@link Identity}.
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Retrieve an existing {@link Identity}
     * @returns 
     */
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<Identity>;
    /**
     * Retrieve mailbox {@link Identity}s
     * @returns 
     */
    getIdentities( __fetchOptions?: RequestOptions): Promise<Array<IdentityDescription>>;
    /**
     * Retrieve all possible mailbox {@link Identity}s (for each email defined in
     * mailbox even if no identies are defined ( if identity doesnt exists for one
     * mail, {@link IdentityDescription#id} will be null
     * @returns 
     */
    getPossibleIdentities( __fetchOptions?: RequestOptions): Promise<Array<IdentityDescription>>;
    /**
     * Update an existing {@link Identity}. An {@link Identity} can be used by a
     * user to set the from header in a mail and add a signature.
     * @param identity 
     */
    update(uid: string, identity?: Identity,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class MailboxIdentityClient extends ApiEndPoint implements IMailboxIdentity {
    domainUid: string;
    mboxUid: string;
    constructor(apiKey: string, domainUid: string, mboxUid: string, base?: string);
    create(uid: string, identity?: Identity,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<Identity>;
    getIdentities( __fetchOptions?: RequestOptions): Promise<Array<IdentityDescription>>;
    getPossibleIdentities( __fetchOptions?: RequestOptions): Promise<Array<IdentityDescription>>;
    update(uid: string, identity?: Identity,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
