
import { ExternalUser } from "./ExternalUser"; 
import { 
    ItemValue
} from "@bluemind/core.container.api";
import { 
    Group
} from "@bluemind/group.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * ExternalUser API. The main use case for this kind of
 * {@link net.bluemind.directory.api.DirEntry} entity is to add an external
 * email to a group.
 */
export interface IExternalUser {
    /**
     * Fetch a {@link ExternalUser} by its external id.
     * @returns {@link ExternalUser}
     *         {@link net.bluemind.core.container.api.ItemValue}, or null if the
     *         {@link ExternalUser} does not exist
     */
    byExtId(extid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<ExternalUser>>;
    /**
     * Creates a new {@link ExternalUser}.
     * @param uid {@link ExternalUser}'s unique id
     * @param externalUser {@link ExternalUser}
     */
    create(uid: string, externalUser?: ExternalUser,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Creates a new {@link ExternalUser} with the given uid. Associates an external
     * id to the {@link ExternalUser}.
     * @param uid the {@link ExternalUser}'s unique id
     * @param externalUser {@link ExternalUser}
     */
    createWithExtId(uid: string, extid: string, externalUser?: ExternalUser,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete an external user.
     * @param uid {@link ExternalUser}'s unique id
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Fetch a {@link ExternalUser} by its uid.
     * @param uid {@link ExternalUser}'s unique id
     * @returns {@link ExternalUser}
     *         {@link net.bluemind.core.container.api.ItemValue}, or null if the
     *         {@link ExternalUser} does not exist
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<ExternalUser>>;
    memberOf(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Group>>>;
    memberOfGroups(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Modify an existing external user.
     * @param uid {@link ExternalUser}'s unique id
     * @param externalUser updated {@link ExternalUser}
     */
    update(uid: string, externalUser?: ExternalUser,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class ExternalUserClient extends ApiEndPoint implements IExternalUser {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    byExtId(extid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<ExternalUser>>;
    create(uid: string, externalUser?: ExternalUser,  __fetchOptions?: RequestOptions): Promise<void>;
    createWithExtId(uid: string, extid: string, externalUser?: ExternalUser,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<ExternalUser>>;
    memberOf(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Group>>>;
    memberOfGroups(uid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    update(uid: string, externalUser?: ExternalUser,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
