
import { GenerationStatus } from "./GenerationStatus"; 
/**
 * A generation is a point-in-time snapshot, de-duplicated and compressed of
 * some data.
 *
 * A generation is referenced by a {@link ProtectedPart} which are tied together
 * in a {@link DataProtectGeneration} to represent a complete backup.
 */
export type PartGeneration = {
    id?: number;
    generationId?: number;
    begin?: number;
    end?: number;
    size?: number;
    tag?: string;
    server?: string;
    withWarnings?: boolean;
    withErrors?: boolean;
    valid?: GenerationStatus;
    datatype?: string;
};
