
import { ContainerChangeset } from "./ContainerChangeset"; 
import { ItemFlagFilter } from "./ItemFlagFilter"; 
import { ContainerHierarchyNode } from "./ContainerHierarchyNode"; 
import { ItemValue } from "./ItemValue"; 
import { ItemVersion } from "./ItemVersion"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Grants read access to a {@link ContainerChangeset} of the containers owned by
 * a given ownerUid
 */
export interface IContainersFlatHierarchy {
    /**
     * @returns if successful, return a {@link ContainerChangeset}
     */
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    /**
     * @returns if successful, return a {@link ContainerChangeset} with internal
     *         numeric ids
     */
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    /**
     * @param filter to exclude some items (eg. deleted items)
     * @returns if successful, return a {@link ContainerChangeset} with internal
     *         numeric ids matching the given filter
     */
    filteredChangesetById(since?: number, filter?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<ContainerHierarchyNode>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<ContainerHierarchyNode>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    list( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<ContainerHierarchyNode>>>;
    multipleGetById(ids?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<ContainerHierarchyNode>>>;
    touch(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class ContainersFlatHierarchyClient extends ApiEndPoint implements IContainersFlatHierarchy {
    domainUid: string;
    ownerUid: string;
    constructor(apiKey: string, domainUid: string, ownerUid: string, base?: string);
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    filteredChangesetById(since?: number, filter?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<ContainerHierarchyNode>>;
    getCompleteById(id: number,  __fetchOptions?: RequestOptions): Promise<ItemValue<ContainerHierarchyNode>>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    list( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<ContainerHierarchyNode>>>;
    multipleGetById(ids?: Array<number>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<ContainerHierarchyNode>>>;
    touch(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
