import { 
    TaskRef
} from "@bluemind/core.task.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IVEvent {
    /**
     * Exports all the {@link VEvent} of the container
     */
    exportAll( __fetchOptions?: RequestOptions): Promise<Blob>;
    /**
     * Exports an ICS version of a {@link VEvent}
     * @param uid the {@link VEvent} uid to export
     */
    exportIcs(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Imports an ICS
     */
    importIcs(ics?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
}

export declare class VEventClient extends ApiEndPoint implements IVEvent {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    exportAll( __fetchOptions?: RequestOptions): Promise<Blob>;
    exportIcs(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    importIcs(ics?: ReadableStream<any> | string | Blob,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    getMetadata(): EndPointMetadata;
}
