
import { AddressBookDescriptor } from "./AddressBookDescriptor"; 
import { 
    TaskRef
} from "@bluemind/core.task.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Addressbooks management api
 */
export interface IAddressBooksMgmt {
    backup(containerUid: string, since?: number,  __fetchOptions?: RequestOptions): Promise<Blob>;
    create(containerUid: string, descriptor?: AddressBookDescriptor, isDefault?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(containerUid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(containerUid: string,  __fetchOptions?: RequestOptions): Promise<AddressBookDescriptor>;
    /**
     * reindex an addressbook
     */
    reindex(containerUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * reindex all addressbooks (drop current index and recreate them)
     */
    reindexAll( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * reindex all addressbooks of a domain
     */
    reindexDomain(domain?: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    restore(containerUid: string, restoreStream?: ReadableStream<any> | string | Blob, reset?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    update(containerUid: string, descriptor?: AddressBookDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class AddressBooksMgmtClient extends ApiEndPoint implements IAddressBooksMgmt {
    constructor(apiKey: string, base?: string);
    backup(containerUid: string, since?: number,  __fetchOptions?: RequestOptions): Promise<Blob>;
    create(containerUid: string, descriptor?: AddressBookDescriptor, isDefault?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(containerUid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(containerUid: string,  __fetchOptions?: RequestOptions): Promise<AddressBookDescriptor>;
    reindex(containerUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    reindexAll( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    reindexDomain(domain?: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    restore(containerUid: string, restoreStream?: ReadableStream<any> | string | Blob, reset?: boolean,  __fetchOptions?: RequestOptions): Promise<void>;
    update(containerUid: string, descriptor?: AddressBookDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
