import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Returns common addressbook container UIDs. All related entries are stored
 * within the container
 */
export interface IAddressBookUids {
    /**
     * Returns the UID of collected contacts
     * @returns UID of collected contacts
     */
    getCollectedContactsUserAddressbook(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Returns the default user addressbook UID
     * @returns default user addressbook UID
     */
    getDefaultUserAddressbook(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Returns the UID of user-created addressbooks
     * @returns the UID of the user-created addressbook
     */
    getUserCreatedAddressbook(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Returns the UID of the domain addressbok
     * @param domain id
     *                      the {@link net.bluemind.domain.api.Domain}'s UID
     * @returns UID of the domain addressbok
     */
    getUserVCards(domain: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class AddressBookUidsClient extends ApiEndPoint implements IAddressBookUids {
    constructor(apiKey: string, base?: string);
    getCollectedContactsUserAddressbook(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getDefaultUserAddressbook(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getUserCreatedAddressbook(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getUserVCards(domain: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
