import { 
    TaskRef
} from "@bluemind/core.task.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IVTodo {
    /**
     * Export all {@link VTodo} from a todolist as iCalendar VTodo objects.
     * 
     * @see https://tools.ietf.org/html/rfc5545#section-3.6.2.
     * @returns {@link net.bluemind.core.api.Stream} of iCalendar VTodo list.
     */
    exportAll( __fetchOptions?: RequestOptions): Promise<Blob>;
    /**
     * Export a list of {@link VTodo} as iCalendar VTodo objects
     * 
     * @see https://tools.ietf.org/html/rfc5545#section-3.6.2.
     * @param uids List of {@link ItemValue#uid} to export
     * @returns {@link net.bluemind.core.api.Stream} of iCalendar VTodo list.
     */
    exportTodos(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Blob>;
    /**
     * Imports an ICS
     * @param ics data in ICS format
     * @returns {@link net.bluemind.core.task.api.TaskRef} which can be used to track
     *         this asynchronous operation
     */
    importIcs(ics?: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
}

export declare class VTodoClient extends ApiEndPoint implements IVTodo {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    exportAll( __fetchOptions?: RequestOptions): Promise<Blob>;
    exportTodos(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Blob>;
    importIcs(ics?: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    getMetadata(): EndPointMetadata;
}
