import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './SmimeRevocationClient.json';

export class SmimeRevocationClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, domainUid , base = '') {
        super(apiKey, base + '/api/smime_revocation/{domainUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
    }
    async areRevoked(clients,  __fetchOptions = {}) {
        let __path = this.base + '/revoked_clients';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (clients != null) {
            __options.body = JSON.stringify(clients);
        }
		return this.__fetchContent(__url, __options);
    }
    async fetch(cacert,  __fetchOptions = {}) {
        let __path = this.base + '/fetch';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (cacert != null) {
            __options.body = JSON.stringify(cacert);
        }
		return this.__fetchContent(__url, __options);
    }
    async refreshDomainRevocations( __fetchOptions = {}) {
        let __path = this.base + '/refresh_domain';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async refreshRevocations(uid,  __fetchOptions = {}) {
        let __path = this.base + '/refresh/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
