
import { RevocationResult } from "./RevocationResult"; 
import { SmimeCacertInfos } from "./SmimeCacertInfos"; 
import { SmimeCertClient } from "./SmimeCertClient"; 
import { SmimeCacert } from "./SmimeCacert"; 
import { 
    ItemValue
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * ISmimeRevocation API <br/>
 * Used to verify end-user certificate is not revoked by authorities
 */
export interface ISmimeRevocation {
    /**
     * Check if a certificate serialNumber list is revoked
     * @param clients the client certificates {@link SmimeCertClient}
     * @returns {@link RevocationResult} lists
     */
    areRevoked(clients?: Array<SmimeCertClient>,  __fetchOptions?: RequestOptions): Promise<Array<RevocationResult>>;
    /**
     * Get {@link SmimeRevocation} for a S/MIME CA certificate
     * @param cacert the S/MIME CA certificate {@link SmimeCacert}
     * @returns {@link SmimeRevocation} lists
     */
    fetch(cacert?: ItemValue<SmimeCacert>,  __fetchOptions?: RequestOptions): Promise<SmimeCacertInfos>;
    /**
     * Refresh revocated certificates
     */
    refreshDomainRevocations( __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Refresh revocated certificates
     */
    refreshRevocations(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class SmimeRevocationClient extends ApiEndPoint implements ISmimeRevocation {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    areRevoked(clients?: Array<SmimeCertClient>,  __fetchOptions?: RequestOptions): Promise<Array<RevocationResult>>;
    fetch(cacert?: ItemValue<SmimeCacert>,  __fetchOptions?: RequestOptions): Promise<SmimeCacertInfos>;
    refreshDomainRevocations( __fetchOptions?: RequestOptions): Promise<void>;
    refreshRevocations(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
