import { 
    TaskRef
} from "@bluemind/core.task.api";

import { ResourceDescriptor } from "./ResourceDescriptor"; 
import { EventInfo } from "./EventInfo"; 
import { 
    ItemValue
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Resources API. Resources are used, for example, to create an entity like a
 * vehicle, a meeting room, a video-projector, etc. They can be categorized by
 * type.
 * 
 * Once created, you can invite a resource to a calendar event. It simply means
 * the resource is booked during the time of the event.
 * 
 * Resource are part of a domain (and only one).
 */
export interface IResources {
    /**
     * Compute the transformed template associated to the given resource if any,
     * then append it to the given <code>eventDescription</code>.
     * 
     * @see ResourceTypeDescriptor#templates
     * @returns the modified - or not - <code>eventDescription</code>
     */
    addToEventDescription(uid: string, eventInfo?: EventInfo,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Fetch an existing {@link ResourceDescriptor} by its email.
     * @param email { @link ResourceDescriptor } email
     * @returns {@link ResourceDescriptor}
     *         {@link net.bluemind.core.container.api.ItemValue}, or null if the
     *         {@link ResourceDescriptor} does not exist
     */
    byEmail(email: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<ResourceDescriptor>>;
    /**
     * List all {@link ResourceDescriptor} by type.
     * @param type id { @link net.bluemind.resource.api.type.ResourceType } unique
     *                id
     * @returns list of {@link ResourceDescriptor} uids or null if the type does not
     *         exists or if there are no {@link ResourceDescriptor} matching.
     */
    byType(type: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Creates a {@link ResourceDescriptor}.
     * @param uid { @link ResourceDescriptor } unique id
     * @param resourceDescriptor { {@link ResourceDescriptor }
     */
    create(uid: string, resourceDescriptor?: ResourceDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete an existing {@link ResourceDescriptor}.
     * @param uid { @link ResourceDescriptor } unique id
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Fetch an existing {@link ResourceDescriptor} by its unique id.
     * @param uid { @link ResourceDescriptor } unique id
     * @returns {@link ResourceDescriptor}, or null if the {@link ResourceDescriptor}
     *         does not exist
     */
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<ResourceDescriptor>;
    /**
     * Fetch a {@link ResourceDescriptor} icon.
     * @param uid { @link ResourceDescriptor } unique id
     * @returns icon binary data (png format) or null if the
     *         {@link ResourceDescriptor} does not exist
     */
    getIcon(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    /**
     * Remove the transformed template associated to the given resource from the
     * given <code>eventDescription</code>.
     * 
     * @see ResourceTypeDescriptor#templates
     * @returns the modified - or not - <code>eventDescription</code>
     */
    removeFromEventDescription(uid: string, eventInfo?: EventInfo,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Set a {@link ResourceDescriptor} icon.
     * @param uid { @link ResourceDescriptor } unique id
     * @param icon icon binary data (png format)
     */
    setIcon(uid: string, icon?: ArrayBuffer,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Modify an existing {@link ResourceDescriptor}.
     * @param uid { @link ResourceDescriptor } unique id
     * @param resourceDescriptor updated { {@link ResourceDescriptor }
     */
    update(uid: string, resourceDescriptor?: ResourceDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class ResourcesClient extends ApiEndPoint implements IResources {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    addToEventDescription(uid: string, eventInfo?: EventInfo,  __fetchOptions?: RequestOptions): Promise<string>;
    byEmail(email: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<ResourceDescriptor>>;
    byType(type: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    create(uid: string, resourceDescriptor?: ResourceDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<ResourceDescriptor>;
    getIcon(uid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    removeFromEventDescription(uid: string, eventInfo?: EventInfo,  __fetchOptions?: RequestOptions): Promise<string>;
    setIcon(uid: string, icon?: ArrayBuffer,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, resourceDescriptor?: ResourceDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
