import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns specific notes container UIDs
 */
export interface INoteUids {
    /**
     * Returns the default user notes UID
     * @param uid the {@link net.bluemind.user.api.User} UID
     * @returns default user notes UID
     */
    getDefaultUserNotes(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Returns the UID of user-created notes
     * @returns user notes UID
     */
    getUserCreatedNotes(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class NoteUidsClient extends ApiEndPoint implements INoteUids {
    constructor(apiKey: string, base?: string);
    getDefaultUserNotes(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getUserCreatedNotes(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
