import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './ContainersClient.json';

export class ContainersClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/containers/_manage');
    }
    async all(query,  __fetchOptions = {}) {
        let __path = this.base + '/_list';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async allForUser(domainUid, userUid, query,  __fetchOptions = {}) {
        let __path = this.base + '/_listforuser';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (domainUid != null) {
            __url.searchParams.append("domainUid", domainUid);
        }
        if (userUid != null) {
            __url.searchParams.append("userUid", userUid);
        }
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async allLight(query,  __fetchOptions = {}) {
        let __path = this.base + '/_listLight';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async create(uid, descriptor,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (descriptor != null) {
            __options.body = JSON.stringify(descriptor);
        }
		return this.__fetchContent(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async exists(containerUid,  __fetchOptions = {}) {
        let __path = this.base + '/_exists';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (containerUid != null) {
            __options.body = JSON.stringify(containerUid);
        }
		return this.__fetchContent(__url, __options);
    }
    async get(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getAccessControlLists(containerIds,  __fetchOptions = {}) {
        let __path = this.base + '/_macl';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (containerIds != null) {
            __options.body = JSON.stringify(containerIds);
        }
		return this.__fetchContent(__url, __options);
    }
    async getContainers(containerIds,  __fetchOptions = {}) {
        let __path = this.base + '/_mget';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (containerIds != null) {
            __options.body = JSON.stringify(containerIds);
        }
		return this.__fetchContent(__url, __options);
    }
    async getContainersLight(containerIds,  __fetchOptions = {}) {
        let __path = this.base + '/_mgetLight';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (containerIds != null) {
            __options.body = JSON.stringify(containerIds);
        }
		return this.__fetchContent(__url, __options);
    }
    async getForUser(domainUid, userUid, uid,  __fetchOptions = {}) {
        let __path = this.base + '/_forUser';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (domainUid != null) {
            __url.searchParams.append("domainUid", domainUid);
        }
        if (userUid != null) {
            __url.searchParams.append("userUid", userUid);
        }
        if (uid != null) {
            __url.searchParams.append("uid", uid);
        }
		return this.__fetchContent(__url, __options);
    }
    async getIfPresent(uid,  __fetchOptions = {}) {
        let __path = this.base + '/_ifPresent/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getLight(uid,  __fetchOptions = {}) {
        let __path = this.base + '/_light/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getLightIfPresent(uid,  __fetchOptions = {}) {
        let __path = this.base + '/_ifPresentLight/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async setAccessControlList(uid, entries,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_acl';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (entries != null) {
            __options.body = JSON.stringify(entries);
        }
		return this.__fetchVoid(__url, __options);
    }
    async update(uid, descriptor,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (descriptor != null) {
            __options.body = JSON.stringify(descriptor);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
