
import { ContainerModifiableDescriptor } from "./ContainerModifiableDescriptor"; 
import { PermittedVerbs } from "./PermittedVerbs"; 
import { ItemDescriptor } from "./ItemDescriptor"; 
import { AccessControlEntry } from "./AccessControlEntry"; 
import { ContainerDescriptor } from "./ContainerDescriptor"; 
import { Count } from "./Count"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Management container
 */
export interface IContainerManagement {
    allowOfflineSync(subject: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * @deprecated 
     */
    canAccess(verbsOrRoles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<boolean>;
    canAccessVerbs(verbsOrRoles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<PermittedVerbs>;
    disallowOfflineSync(subject: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Retrieve container ACL
     * @returns List of access control entries
     */
    getAccessControlList( __fetchOptions?: RequestOptions): Promise<Array<AccessControlEntry>>;
    /**
     * Get all container items
     * @returns {@link ItemDescriptor} list
     */
    getAllItems( __fetchOptions?: RequestOptions): Promise<Array<ItemDescriptor>>;
    /**
     * Retrieve container descriptor
     * @returns {@link ContainerDescriptor}
     */
    getDescriptor( __fetchOptions?: RequestOptions): Promise<ContainerDescriptor>;
    getItemCount( __fetchOptions?: RequestOptions): Promise<Count>;
    /**
     * Get container items
     * @returns {@link ItemDescriptor} list
     */
    getItems(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemDescriptor>>;
    /**
     * Get container settings
     */
    getSettings( __fetchOptions?: RequestOptions): Promise<Record<string, string>>;
    /**
     * store container ACL
     * @param entries acl
     */
    setAccessControlList(entries?: Array<AccessControlEntry>,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Set container personal settings
     */
    setPersonalSettings(settings?: Record<string, string>,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Set a container setting, only one key at a time
     * @param key string: look ContainerSettingsKeys
     */
    setSetting(key: string, value?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Set container settings
     */
    setSettings(settings?: Record<string, string>,  __fetchOptions?: RequestOptions): Promise<void>;
    subscribers( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Update container descriptor
     */
    update(descriptor?: ContainerModifiableDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class ContainerManagementClient extends ApiEndPoint implements IContainerManagement {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    allowOfflineSync(subject: string,  __fetchOptions?: RequestOptions): Promise<void>;
    canAccess(verbsOrRoles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<boolean>;
    canAccessVerbs(verbsOrRoles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<PermittedVerbs>;
    disallowOfflineSync(subject: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getAccessControlList( __fetchOptions?: RequestOptions): Promise<Array<AccessControlEntry>>;
    getAllItems( __fetchOptions?: RequestOptions): Promise<Array<ItemDescriptor>>;
    getDescriptor( __fetchOptions?: RequestOptions): Promise<ContainerDescriptor>;
    getItemCount( __fetchOptions?: RequestOptions): Promise<Count>;
    getItems(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemDescriptor>>;
    getSettings( __fetchOptions?: RequestOptions): Promise<Record<string, string>>;
    setAccessControlList(entries?: Array<AccessControlEntry>,  __fetchOptions?: RequestOptions): Promise<void>;
    setPersonalSettings(settings?: Record<string, string>,  __fetchOptions?: RequestOptions): Promise<void>;
    setSetting(key: string, value?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    setSettings(settings?: Record<string, string>,  __fetchOptions?: RequestOptions): Promise<void>;
    subscribers( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    update(descriptor?: ContainerModifiableDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
