
import { CalendarLookupResponse } from "./CalendarLookupResponse"; 
import { 
    Verb
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface ICalendarAutocomplete {
    calendarGroupLookup(groupUid: string,  __fetchOptions?: RequestOptions): Promise<Array<CalendarLookupResponse>>;
    /**
     * Lookup for calendar container
     * @param pattern the search pattern
     */
    calendarLookup(pattern: string, verb?: Verb,  __fetchOptions?: RequestOptions): Promise<Array<CalendarLookupResponse>>;
}

export declare class CalendarAutocompleteClient extends ApiEndPoint implements ICalendarAutocomplete {
    constructor(apiKey: string, base?: string);
    calendarGroupLookup(groupUid: string,  __fetchOptions?: RequestOptions): Promise<Array<CalendarLookupResponse>>;
    calendarLookup(pattern: string, verb?: Verb,  __fetchOptions?: RequestOptions): Promise<Array<CalendarLookupResponse>>;
    getMetadata(): EndPointMetadata;
}
