import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * API to fetch user's inbox information
 */
export interface IUserInbox {
    unseen( __fetchOptions?: RequestOptions): Promise<number>;
}

export declare class UserInboxClient extends ApiEndPoint implements IUserInbox {
    domainUid: string;
    userUid: string;
    constructor(apiKey: string, domainUid: string, userUid: string, base?: string);
    unseen( __fetchOptions?: RequestOptions): Promise<number>;
    getMetadata(): EndPointMetadata;
}
