import { 
    ItemIdentifier,
    Ack
} from "@bluemind/core.container.api";

import { ConversationFlagUpdate } from "./ConversationFlagUpdate"; 
import { ImportMailboxItemsStatus } from "./ImportMailboxItemsStatus"; 
import { ImportMailboxConversationSet } from "./ImportMailboxConversationSet"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Handle message conversations for a given container (per user or mail-share).
 */
export interface IMailConversationActions {
    /**
     * Adds one flag to multiple
     * {@link net.bluemind.backend.mail.api.Conversation}s.
     * @returns the new container version
     */
    addFlag(flagUpdate?: ConversationFlagUpdate,  __fetchOptions?: RequestOptions): Promise<Ack>;
    /**
     * Copy conversations.
     * @returns 
     */
    copy(targetMailboxUid: string, conversationUids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemIdentifier>>;
    /**
     * Removes a flag from multiple
     * {@link net.bluemind.backend.mail.api.Conversation}s.
     * @returns the new container version
     */
    deleteFlag(flagUpdate?: ConversationFlagUpdate,  __fetchOptions?: RequestOptions): Promise<Ack>;
    /**
     * Import conversations into folder.
     */
    importItems(folderDestinationId: number, mailboxItems?: ImportMailboxConversationSet,  __fetchOptions?: RequestOptions): Promise<ImportMailboxItemsStatus>;
    /**
     * Move conversations.
     * @returns 
     */
    move(targetMailboxUid: string, conversationUids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemIdentifier>>;
    /**
     * Delete conversations.
     * @param conversationUids 
     */
    multipleDeleteById(conversationUids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class MailConversationActionsClient extends ApiEndPoint implements IMailConversationActions {
    conversationContainer: string;
    replicatedMailboxUid: string;
    constructor(apiKey: string, conversationContainer: string, replicatedMailboxUid: string, base?: string);
    addFlag(flagUpdate?: ConversationFlagUpdate,  __fetchOptions?: RequestOptions): Promise<Ack>;
    copy(targetMailboxUid: string, conversationUids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemIdentifier>>;
    deleteFlag(flagUpdate?: ConversationFlagUpdate,  __fetchOptions?: RequestOptions): Promise<Ack>;
    importItems(folderDestinationId: number, mailboxItems?: ImportMailboxConversationSet,  __fetchOptions?: RequestOptions): Promise<ImportMailboxItemsStatus>;
    move(targetMailboxUid: string, conversationUids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemIdentifier>>;
    multipleDeleteById(conversationUids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
