import { 
    TaskRef
} from "@bluemind/core.task.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IVCardService {
    exportAll( __fetchOptions?: RequestOptions): Promise<string>;
    exportCards(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * @param vcard one and only one card
     * @returns vcard uid
     */
    importCards(vcard?: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
}

export declare class VCardServiceClient extends ApiEndPoint implements IVCardService {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    exportAll( __fetchOptions?: RequestOptions): Promise<string>;
    exportCards(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<string>;
    importCards(vcard?: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    getMetadata(): EndPointMetadata;
}
