import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './AddressBookUidsClient.json';

export class AddressBookUidsClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/addressbook/uids');
    }
    async getCollectedContactsUserAddressbook(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_collected_contacts';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getDefaultUserAddressbook(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_default_addressbook';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getUserCreatedAddressbook(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_other_addressbook';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getUserVCards(domain,  __fetchOptions = {}) {
        let __path = this.base + '/{domain}/_vcards';
        __path = __path.replace('{domain}', encodeURIComponent(domain));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
