import { 
    IdentityDescription
} from "@bluemind/mailbox.identity.api";

import { UserMailIdentity } from "./UserMailIdentity"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IUserMailIdentities {
    /**
     * Create an {@link Identity}. An {@link UserMailIdentity} can be used by a user
     * to set the from header in a mail and add a signature.
     * @param identity 
     */
    create(uid: string, identity?: UserMailIdentity,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete an existing {@link UserMailIdentity}.
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Retrieve an existing {@link UserMailIdentity}
     * @returns 
     */
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<UserMailIdentity>;
    /**
     * Retrieve mailbox {@link Identity}s
     * @returns 
     */
    getAvailableIdentities( __fetchOptions?: RequestOptions): Promise<Array<IdentityDescription>>;
    /**
     * Retrieve user {@link UserMailIdentity}s
     * @returns 
     */
    getIdentities( __fetchOptions?: RequestOptions): Promise<Array<IdentityDescription>>;
    setDefault(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Update an existing {@link UserMailIdentity}. An {@link UserMailIdentity} can
     * be used by a user to set the from header in a mail and add a signature.
     * @param identity 
     */
    update(uid: string, identity?: UserMailIdentity,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class UserMailIdentitiesClient extends ApiEndPoint implements IUserMailIdentities {
    domainUid: string;
    userUid: string;
    constructor(apiKey: string, domainUid: string, userUid: string, base?: string);
    create(uid: string, identity?: UserMailIdentity,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<UserMailIdentity>;
    getAvailableIdentities( __fetchOptions?: RequestOptions): Promise<Array<IdentityDescription>>;
    getIdentities( __fetchOptions?: RequestOptions): Promise<Array<IdentityDescription>>;
    setDefault(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, identity?: UserMailIdentity,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
