import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './UserClient.json';

export class UserClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, domainUid , base = '') {
        super(apiKey, base + '/api/users/{domainUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
    }
    async allUids( __fetchOptions = {}) {
        let __path = this.base + '/_alluids';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async byEmail(email,  __fetchOptions = {}) {
        let __path = this.base + '/byEmail/{email}';
        __path = __path.replace('{email}', encodeURIComponent(email));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async byExtId(extid,  __fetchOptions = {}) {
        let __path = this.base + '/byExtId/{extid}';
        __path = __path.replace('{extid}', encodeURIComponent(extid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async byLogin(login,  __fetchOptions = {}) {
        let __path = this.base + '/byLogin/{login}';
        __path = __path.replace('{login}', encodeURIComponent(login));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async create(uid, user,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (user != null) {
            __options.body = JSON.stringify(user);
        }
		return this.__fetchVoid(__url, __options);
    }
    async createWithExtId(uid, extid, user,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/{extid}/createwithextid';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        __path = __path.replace('{extid}', encodeURIComponent(extid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (user != null) {
            __options.body = JSON.stringify(user);
        }
		return this.__fetchVoid(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async deletePhoto(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/photo';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async enablePerUserLog(userUid, endpoint, enable,  __fetchOptions = {}) {
        let __path = this.base + '/{userUid}/_logging/{endpoint}';
        __path = __path.replace('{userUid}', encodeURIComponent(userUid));
        __path = __path.replace('{endpoint}', encodeURIComponent(endpoint));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (enable != null) {
            __options.body = JSON.stringify(enable);
        }
		return this.__fetchVoid(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/complete';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getIcon(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/icon';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getLight(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/light';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getLocale(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/locale';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getMultipleVcardOnly(uids,  __fetchOptions = {}) {
        let __path = this.base + '/_mgetvcardonly';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (uids != null) {
            __options.body = JSON.stringify(uids);
        }
		return this.__fetchContent(__url, __options);
    }
    async getPhoto(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/photo';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getResolvedRoles(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/roles_resolved';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getRoles(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/roles';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getUsersWithRoles(roles,  __fetchOptions = {}) {
        let __path = this.base + '/_roleusers';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (roles != null) {
            __options.body = JSON.stringify(roles);
        }
		return this.__fetchContent(__url, __options);
    }
    async getVCard(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/vcard';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async memberOf(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/groups';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async memberOfGroups(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/groupUids';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async setExtId(uid, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_extId';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setPassword(uid, password,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/password_';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (password != null) {
            __options.body = JSON.stringify(password);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setPhoto(uid, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/photo';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchVoid(__url, __options);
    }
    async setRoles(uid, roles,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/roles';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (roles != null) {
            __options.body = JSON.stringify(roles);
        }
		return this.__fetchVoid(__url, __options);
    }
    async update(uid, user,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (user != null) {
            __options.body = JSON.stringify(user);
        }
		return this.__fetchVoid(__url, __options);
    }
    async updateAccountType(uid, accountType,  __fetchOptions = {}) {
        let __path = this.base + '/_updateAccountType/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (accountType != null) {
            __options.body = JSON.stringify(accountType);
        }
		return this.__fetchVoid(__url, __options);
    }
    async updateVCard(uid, userVCard,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/vcard';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (userVCard != null) {
            __options.body = JSON.stringify(userVCard);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
