
import { TagChanges } from "./TagChanges"; 
import { Tag } from "./Tag"; 
import { 
    ContainerChangeset,
    ContainerUpdatesResult,
    ItemValue
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * This API is used to manage per-user & per-domain lists of {@link Tag}
 * (keyword and color).
 * 
 * The containerUid is obtained from {@link ITagUids#getDefaultUserTags(String)}
 * or can be a domain uid (ie. domain name).
 */
export interface ITags {
    /**
     * Find all {@link Tag}s. Domain tags are not returned when this method is
     * invoked on {@link ITagUids#defaultTags(String)}.
     * @returns list of {@link Tag}s
     */
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Tag>>>;
    /**
     * List all {@link Tag} uids in the container.
     * @returns a list of {@link Tag} uid
     */
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * {@link ContainerChangeset} of the container starting at given version.
     * @param since version of first change to retrieve
     */
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    /**
     * Create a new {@link Tag}. Tags can be associated with items and may be used
     * to categorize items or for searching.
     * @param uid The unique identifier
     * @param tag {@link Tag} that will be created.
     */
    create(uid: string, tag?: Tag,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete a {@link Tag}.
     * @param uid The unique identifier of the {@link Tag}
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Fetch a {@link Tag} from its uid.
     * @param uid The unique identifier
     * @returns {@link ItemValue<Tag>}
     */
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Tag>>;
    /**
     * Fetch multiple {@link Tag}s from their uids.
     * @param uids the unique identifiers to fetch
     * @returns a list of {@link ItemValue<Tag>}
     */
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Tag>>>;
    /**
     * Update a {@link Tag}.
     * @param uid The unique identifier
     * @param tag {@link Tag} that will be created.
     */
    update(uid: string, tag?: Tag,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Update multiple tags at once.
     * @param changes the batch of changes to apply
     */
    updates(changes?: TagChanges,  __fetchOptions?: RequestOptions): Promise<ContainerUpdatesResult>;
}

export declare class TagsClient extends ApiEndPoint implements ITags {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Tag>>>;
    allUids( __fetchOptions?: RequestOptions): Promise<Array<string>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    create(uid: string, tag?: Tag,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Tag>>;
    multipleGet(uids?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<Tag>>>;
    update(uid: string, tag?: Tag,  __fetchOptions?: RequestOptions): Promise<void>;
    updates(changes?: TagChanges,  __fetchOptions?: RequestOptions): Promise<ContainerUpdatesResult>;
    getMetadata(): EndPointMetadata;
}
