import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './SystemConfigurationClient.json';

export class SystemConfigurationClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/configuration');
    }
    async getValues( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async updateMutableValues(values,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (values != null) {
            __options.body = JSON.stringify(values);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
