import { 
    TaskRef
} from "@bluemind/core.task.api";

import { CertData } from "./CertData"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface ISecurityMgmt {
    /**
     * Accept Let's Encrypt terms of service document
     */
    approveLetsEncryptTos(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Generate Let's Encrypt certificate
     * @param certData Certificate data
     */
    generateLetsEncrypt(certData?: CertData,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Get the URL to Let's Encrypt terms of service document
     * @returns URL
     */
    getLetsEncryptTos( __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Update external certificate/private key
     * @param certData Certificate data
     */
    updateCertificate(certData?: CertData,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class SecurityMgmtClient extends ApiEndPoint implements ISecurityMgmt {
    constructor(apiKey: string, base?: string);
    approveLetsEncryptTos(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    generateLetsEncrypt(certData?: CertData,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    getLetsEncryptTos( __fetchOptions?: RequestOptions): Promise<string>;
    updateCertificate(certData?: CertData,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
