import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './GlobalSettingsClient.json';

export class GlobalSettingsClient extends ApiEndPoint {
    version = "5.4.2696";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/global_settings');
    }
    async delete(key,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
        if (key != null) {
            __url.searchParams.append("key", key);
        }
		return this.__fetchVoid(__url, __options);
    }
    async get( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async set(settings,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (settings != null) {
            __options.body = JSON.stringify(settings);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
